/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.entity;

import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.position.BlockPosition;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.BlockDuct;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.duct.entity.TileTransportDuctBase;
import cofh.thermaldynamics.duct.entity.TileTransportDuctCrossover;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileTransportDuctLongRange
extends TileTransportDuctBase {
    byte d1;
    byte d2;
    byte connections;

    @Override
    public MultiBlockGrid getNewGrid() {
        return null;
    }

    @Override
    public void onNeighborBlockChange() {
        this.d1 = (byte)7;
        this.d2 = (byte)7;
        super.onNeighborBlockChange();
        this.checkConnections();
    }

    @Override
    public void onNeighborTileChange(int n, int n2, int n3) {
        this.d1 = (byte)7;
        this.d2 = (byte)7;
        super.onNeighborTileChange(n, n2, n3);
        this.checkConnections();
    }

    public void checkConnections() {
        this.connections = 0;
        for (int n = 5; n > 0; n = (int)((byte)(n - 1))) {
            if (this.neighborTypes[n] == TileTDBase.NeighborTypes.NONE) continue;
            if (this.connections == 0) {
                this.d1 = (byte)n;
                this.connections = 1;
                continue;
            }
            if (this.connections == 1) {
                this.d2 = (byte)n;
                this.connections = (byte)2;
                continue;
            }
            this.d1 = (byte)7;
            this.d2 = (byte)7;
            this.connections = (byte)3;
            break;
        }
    }

    @Override
    public void formGrid() {
    }

    @Override
    public boolean isValidForForming() {
        return false;
    }

    public byte nextDirection(byte by) {
        if (this.connections != 2) {
            return -1;
        }
        if ((by ^ 1) == this.d1) {
            return this.d2;
        }
        if ((by ^ 1) == this.d2) {
            return this.d1;
        }
        return -1;
    }

    @Override
    public void handleTileSideUpdate(int n) {
        super.handleTileSideUpdate(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean advanceEntity(EntityTransport entityTransport) {
        int n = entityTransport.progress;
        entityTransport.progress = (byte)((n += entityTransport.step * 2) % 100);
        if (n < 100) {
            if (entityTransport.progress < 50) return false;
            if (entityTransport.progress - entityTransport.step >= 50) return false;
            if (this.neighborTypes[entityTransport.direction] != TileTDBase.NeighborTypes.NONE) return false;
            entityTransport.dropPassenger();
            return true;
        }
        if (this.neighborTypes[entityTransport.direction] == TileTDBase.NeighborTypes.MULTIBLOCK && this.connectionTypes[entityTransport.direction] == TileTDBase.ConnectionTypes.NORMAL) {
            TileTransportDuctBase tileTransportDuctBase = (TileTransportDuctBase)this.getConnectedSide(entityTransport.direction);
            tileTransportDuctBase.onNeighborBlockChange();
            if (tileTransportDuctBase.neighborTypes[entityTransport.direction ^ 1] != TileTDBase.NeighborTypes.MULTIBLOCK) return false;
            entityTransport.pos = new BlockPosition((TileEntity)tileTransportDuctBase);
            entityTransport.oldDirection = entityTransport.direction;
            if (tileTransportDuctBase instanceof TileTransportDuctLongRange) {
                TileTransportDuctLongRange tileTransportDuctLongRange = (TileTransportDuctLongRange)tileTransportDuctBase;
                entityTransport.direction = tileTransportDuctLongRange.nextDirection(entityTransport.direction);
                if (entityTransport.direction != -1) return false;
                entityTransport.dropPassenger();
                return true;
            }
            if (entityTransport.myPath == null) return false;
            if (entityTransport.myPath.hasNextDirection()) {
                entityTransport.direction = entityTransport.myPath.getNextDirection();
                return false;
            }
            entityTransport.reRoute = true;
            return false;
        }
        entityTransport.dropPassenger();
        return true;
    }

    @Override
    public boolean advanceEntityClient(EntityTransport entityTransport) {
        int n = entityTransport.progress;
        entityTransport.progress = (byte)((n += entityTransport.step + entityTransport.step) % 100);
        return n >= 100 && !entityTransport.trySimpleAdvance();
    }

    @Override
    public boolean isConnectable(TileEntity tileEntity, int n) {
        return tileEntity instanceof TileTransportDuctLongRange || tileEntity instanceof TileTransportDuctCrossover;
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("SimpleConnect", this.connections);
        nBTTagCompound.func_74774_a("SimpleConnect1", this.d1);
        nBTTagCompound.func_74774_a("SimpleConnect2", this.d2);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.connections = nBTTagCompound.func_74771_c("SimpleConnect");
        this.d1 = nBTTagCompound.func_74771_c("SimpleConnect1");
        this.d2 = nBTTagCompound.func_74771_c("SimpleConnect2");
    }

    @Override
    public BlockDuct.ConnectionTypes getRenderConnectionType(int n) {
        BlockDuct.ConnectionTypes connectionTypes = super.getRenderConnectionType(n);
        if (connectionTypes == BlockDuct.ConnectionTypes.NONE || this.connections == 0) {
            return connectionTypes;
        }
        if (n != this.d1 && n != this.d2) {
            return BlockDuct.ConnectionTypes.NONE;
        }
        TileEntity tileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)n);
        if (tileEntity != null && tileEntity.getClass() == TileTransportDuctLongRange.class) {
            TileTransportDuctLongRange tileTransportDuctLongRange = (TileTransportDuctLongRange)tileEntity;
            if ((tileTransportDuctLongRange.d1 ^ 1) == n || (tileTransportDuctLongRange.d2 ^ 1) == n) {
                return connectionTypes;
            }
            return BlockDuct.ConnectionTypes.NONE;
        }
        return connectionTypes;
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addShort(this.connections << 6 | this.d1 << 3 | this.d2);
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        short s = packetCoFHBase.getShort();
        this.connections = (byte)(s >> 6 & 7);
        this.d1 = (byte)(s >> 3 & 7);
        this.d2 = (byte)(s & 7);
    }
}

